<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 11:00
 */
interface BillsproductsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Billsproducts 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param billsproduct primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Billsproducts billsproduct
 	 */
	public function insert($billsproduct);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Billsproducts billsproduct
 	 */
	public function update($billsproduct);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBillid($value);

	public function queryByProductid($value);

	public function queryByNote($value);

	public function queryByProductno($value);

	public function queryByProductprice($value);

	public function queryByProducttotalprice($value);

	public function queryByDeleted($value);

	public function queryByService($value);


	public function deleteByBillid($value);

	public function deleteByProductid($value);

	public function deleteByNote($value);

	public function deleteByProductno($value);

	public function deleteByProductprice($value);

	public function deleteByProducttotalprice($value);

	public function deleteByDeleted($value);

	public function deleteByService($value);


}
?>